
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bubble_tea_optimization")

# Create decision variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # Almond tea
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # Ginger tea

# Set objective function
m.setObjective(5*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 120, "almond_demand")
m.addConstr(x2 <= 200, "ginger_demand")
m.addConstr(x1 + x2 <= 300, "total_production")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal}")
    print(f"Almond Bubble Tea Bottles: {x1.x}")
    print(f"Ginger Bubble Tea Bottles: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

