
from gurobipy import *

# Create a new model
m = Model("Bubble_Tea_Optimization")

# Decision variables
x1 = m.addVar(lb=0, name="almond_bubble_tea")
x2 = m.addVar(lb=0, name="ginger_bubble_tea")

# Objective function: Maximize profit
m.setObjective(5*x1 + 9*x2, GRB.MAXIMIZE)

# Demand constraints
m.addConstr(x1 <= 120, "almond_demand")
m.addConstr(x2 <= 200, "ginger_demand")

# Production capacity constraint
m.addConstr(x1 + x2 <= 300, "production_capacity")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f" Produce {x1.x} bottles of almond bubble tea")
    print(f" Produce {x2.x} bottles of ginger bubble tea")
    print(f" Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
