
import gurobi

def solve_bubble_tea_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="almond_bubble_tea")  # Number of almond bubble tea bottles
    x2 = model.addVar(lb=0, name="ginger_bubble_tea")  # Number of ginger bubble tea bottles

    # Objective function: Maximize profit
    model.setObjective(5*x1 + 9*x2, gurobi.GRB.MAXIMIZE)

    # Demand constraints
    model.addConstr(x1 <= 120, name="almond_demand_constraint")
    model.addConstr(x2 <= 200, name="ginger_demand_constraint")

    # Production capacity constraint
    model.addConstr(x1 + x2 <= 300, name="production_capacity_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: ${5*x1.varValue + 9*x2.varValue:.2f}")
    else:
        print("No optimal solution found.")

# Run the function
solve_bubble_tea_problem()
