
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Luke's Farm")

# Create variables
x = m.addVar(lb=0, name="carrots") # hectares of carrots
y = m.addVar(lb=0, name="pumpkins") # hectares of pumpkins

# Set objective function
m.setObjective(300*x + 500*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 200, "land_availability")
m.addConstr(x >= y, "carrot_preference")
m.addConstr(x <= 2*y, "soil_weather")
m.addConstr(x >= 25, "min_carrots")
m.addConstr(y >= 20, "min_pumpkins")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} hectares of carrots")
    print(f"Plant {y.x:.2f} hectares of pumpkins")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

