
from gurobipy import *

# Create a new model
m = Model("Luke's Farm")

# Decision Variables
C = m.addVar(lb=25, name="Carrots")  # Minimum 25 hectares of carrots
P = m.addVar(lb=20, name="Pumpkins")  # Minimum 20 hectares of pumpkins

# Objective Function: Maximize profit
m.setObjective(300*C + 500*P, GRB.MAXIMIZE)

# Constraints
m.addConstr(C + P <= 200, "Total_Land")  # Total land constraint
m.addConstr(C <= 2*P, "Carrot_to_Pumpkin_Ratio")  # Carrot to pumpkin ratio

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {C.varName} = {C.x}, {P.varName} = {P.x}")
    print(f"Maximum Profit: ${300*C.x + 500*P.x}")
else:
    print("No optimal solution found")
