
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    C = model.addVar(lb=0, name="Carrots")
    P = model.addVar(lb=0, name="Pumpkins")

    # Update model to include new variables
    model.update()

    # Objective function: Maximize profit
    model.setObjective(300*C + 500*P, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(C + P <= 200, name="Total_Land")
    model.addConstr(C <= 2*P, name="Carrots_to_Pumpkins_Ratio")
    model.addConstr(C >= 25, name="Minimum_Carrots")
    model.addConstr(P >= 20, name="Minimum_Pumpkins")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        # Get the optimal values
        optimal_carrots = C.varValue
        optimal_pumpkins = P.varValue
        optimal_profit = model.objVal

        print(f"Optimal hectares of carrots: {optimal_carrots}")
        print(f"Optimal hectares of pumpkins: {optimal_pumpkins}")
        print(f"Optimal profit: ${optimal_profit}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
