
import gurobipy as gp

# Create a new model
m = gp.Model("Network_Design")

# Create variables
x = m.addVar(vtype=gp.GRB.INTEGER, name="x") # ring layouts
y = m.addVar(vtype=gp.GRB.INTEGER, name="y") # tree layouts
z = m.addVar(vtype=gp.GRB.INTEGER, name="z") # mesh layouts


# Set objective function
m.setObjective(2000*x + 4000*y + 8000*z, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x + 30*y + 100*z <= 2000, "Workstation_Constraint")
m.addConstr(20*x + 15*y + 50*z <= 500, "Server_Constraint")
m.addConstr(10*x + 7*y + 30*z <= 300, "Switch_Constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of ring layouts (x): {x.x}")
    print(f"Number of tree layouts (y): {y.x}")
    print(f"Number of mesh layouts (z): {z.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

