
from gurobipy import *

# Create a new model
m = Model("Nova_Network")

# Define decision variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="ring_layouts")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="tree_layouts")
x3 = m.addVar(lb=0, vtype=GRB.INTEGER, name="mesh_layouts")

# Define the objective function
m.setObjective(2000*x1 + 4000*x2 + 8000*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x1 + 30*x2 + 100*x3 <= 2000, name="workstations")
m.addConstr(20*x1 + 15*x2 + 50*x3 <= 500, name="servers")
m.addConstr(10*x1 + 7*x2 + 30*x3 <= 300, name="switches")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ring layouts: {x1.x}")
    print(f"Tree layouts: {x2.x}")
    print(f"Mesh layouts: {x3.x}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
