
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    R = model.addVar(lb=0, name="R")  # ring layout
    T = model.addVar(lb=0, name="T")  # tree layout
    M = model.addVar(lb=0, name="M")  # mesh layout

    # Objective function: Maximize profit
    model.setObjective(2000*R + 4000*T + 8000*M, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(50*R + 30*T + 100*M <= 2000, name="workstations")
    model.addConstr(20*R + 15*T + 50*M <= 500, name="servers")
    model.addConstr(10*R + 7*T + 30*M <= 300, name="switches")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Ring Layouts: {R.varValue}")
        print(f"Tree Layouts: {T.varValue}")
        print(f"Mesh Layouts: {M.varValue}")
        print(f"Maximum Profit: {model.objVal}")
    else:
        print("The model is infeasible")

if __name__ == "__main__":
    solve_optimization_problem()
