
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("computer_sales")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="laptops") # Number of laptops
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="desktops") # Number of desktops

# Set objective function
m.setObjective(210*x + 160*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(500*x + 400*y <= 20000, "budget")
m.addConstr(x >= 20, "min_laptops")
m.addConstr(x <= 35, "max_laptops")
m.addConstr(y <= (1/3)*x, "desktop_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of laptops to sell: {x.x}")
    print(f"Number of desktops to sell: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

