
from gurobipy import *

# Create a new model
m = Model("Computer_Sales")

# Define the decision variables
x = m.addVar(lb=20, ub=35, vtype=GRB.INTEGER, name="laptops")
y = m.addVar(vtype=GRB.INTEGER, name="desktops")

# Set the objective function to maximize profit
m.setObjective(210*x + 160*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(500*x + 400*y <= 20000, "Budget_Constraint")
m.addConstr(y <= (1/3)*x, "Desktop_to_Laptop_Ratio")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of laptops to sell: {x.x}")
    print(f"Number of desktops to sell: {y.x}")
    print(f"Maximum profit: ${210*x.x + 160*y.x:.2f}")
else:
    print("No optimal solution found")
