
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
L = model.addVar(lb=20, ub=35, name="Laptop")
D = model.addVar(name="Desktop")

# Objective function: Maximize profit
model.setObjective(210*L + 160*D, gurobi.GRB.MAXIMIZE)

# Budget constraint
model.addConstr(500*L + 400*D <= 20000, name="Budget")

# Desktop sales constraint relative to laptops
model.addConstr(D <= L/3, name="Desktop_to_Laptop_Ratio")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print(f"Optimal profit: {model.objVal}")
    print(f"Laptops to sell: {L.varValue}")
    print(f"Desktops to sell: {D.varValue}")
else:
    print("The model is infeasible")
