
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Julia's Diet")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Protein_Bars")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Meal_Replacement_Shakes")

# Set objective function
m.setObjective(10*x + 15*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(30*x + 10*y >= 155, "Protein_Requirement")
m.addConstr(50*x + 20*y >= 140, "Carb_Requirement")
m.addConstr(2*x + 5*y <= 55, "Fat_Limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Number of Protein Bars: {x.x:.2f}")
    print(f"Number of Meal Replacement Shakes: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

