
import gurobi

def solve_diet_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="vanilla_protein_bars", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="organic_meal_replacement_shakes", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(10*x + 15*y, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(30*x + 10*y >= 155, name="protein_requirement")
    model.addConstr(50*x + 20*y >= 140, name="carbs_requirement")
    model.addConstr(2*x + 5*y <= 55, name="fat_limit")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Vanilla protein bars: {x.varValue}")
        print(f"Organic meal replacement shakes: {y.varValue}")
        print(f"Total cost: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_diet_problem()
