
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("theta_electronics")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="keyboards") # Allowing fractional keyboards and controllers for simplicity.  If only whole numbers are allowed, change vtype to GRB.INTEGER
y = m.addVar(vtype=GRB.CONTINUOUS, name="controllers")

# Set objective function
m.setObjective(20*x + 10*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x + 4*y <= 200, "space_constraint")
m.addConstr(y >= 0.35*(x + y), "controller_proportion")
m.addConstr(200*x + 150*y <= 5000, "capital_constraint")
m.addConstr(x >= 0, "nonneg_x")  # Explicit non-negativity constraints
m.addConstr(y >= 0, "nonneg_y")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal:.2f}")
    print(f"Number of Keyboards: {x.x:.2f}")
    print(f"Number of PC Controllers: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

