
from gurobipy import *

# Create a new model
m = Model("Theta_Electronics_Problem")

# Define variables
K = m.addVar(vtype=GRB.INTEGER, name="Keyboards")
P = m.addVar(vtype=GRB.INTEGER, name="PC_Controllers")

# Objective function: Maximize profit
m.setObjective(20*K + 10*P, GRB.MAXIMIZE)

# Constraints
# 1. Floor space constraint
m.addConstr(12*K + 4*P <= 200, "Floor_Space_Constraint")
# 2. PC controllers percentage constraint
m.addConstr(P >= (7/13)*K, "PC_Controllers_Percentage_Constraint")
# 3. Capital constraint
m.addConstr(200*K + 150*P <= 5000, "Capital_Constraint")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")
