
import gurobi

def solve_theta_electronics_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    K = model.addVar(lb=0, name="Keyboards")  # Number of keyboards
    C = model.addVar(lb=0, name="Controllers")  # Number of PC controllers

    # Objective function: Maximize profit
    model.setObjective(20*K + 10*C, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12*K + 4*C <= 200, name="FloorSpace")  # Floor space constraint
    model.addConstr(-0.35*K + 0.65*C >= 0, name="ProductMix")  # Product mix constraint
    model.addConstr(200*K + 150*C <= 5000, name="Capital")  # Capital constraint

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Keyboards: {K.varValue}, Controllers: {C.varValue}, Profit: ${20*K.varValue + 10*C.varValue}")
    else:
        print("No optimal solution found.")

solve_theta_electronics_problem()
