
from gurobipy import *

# Create a model
m = Model("Ad Placement")

# Define the decision variables
x1 = m.addVar(vtype=GRB.INTEGER, name="DIY")
x2 = m.addVar(vtype=GRB.INTEGER, name="Shopping")
x3 = m.addVar(vtype=GRB.INTEGER, name="Unboxing")

# Objective function: Maximize total viewership
m.setObjective(10000*x1 + 4000*x2 + 9000*x3, GRB.MAXIMIZE)

# Budget constraint
m.addConstr(5000*x1 + 3200*x2 + 4000*x3 <= 120000, name="Budget")

# DIY video constraint
m.addConstr(x1 <= 5, name="DIY Limit")

# Unboxing video constraint
m.addConstr(x3 <= 0.5*(x1 + x2 + x3), name="Unboxing Limit")

# Shopping video constraint
m.addConstr(x2 >= 0.2*(x1 + x2 + x3), name="Shopping Minimum")

# Non-negativity constraints (not necessary here since we've set vtype=GRB.INTEGER and all coefficients are positive)

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective: {m.objVal}")
