
import gurobipy as gp

# Create a new model
m = gp.Model("Ad_Placement")

# Decision variables
x1 = m.addVar(name="DIY_ads", lb=0, ub=5, vtype=gp.GRB.INTEGER)  # DIY ads
x2 = m.addVar(name="shopping_ads", lb=0, vtype=gp.GRB.INTEGER)  # Shopping ads
x3 = m.addVar(name="unboxing_ads", lb=0, vtype=gp.GRB.INTEGER)  # Unboxing ads

# Objective: Maximize viewership
m.setObjective(10000*x1 + 4000*x2 + 9000*x3, gp.GRB.MAXIMIZE)

# Budget constraint
m.addConstr(5000*x1 + 3200*x2 + 4000*x3 <= 120000, name="budget_constraint")

# DIY ads limitation
m.addConstr(x1 <= 5, name="diy_limitation")

# Unboxing ads limitation
m.addConstr(0.5*x1 + 0.5*x2 - 0.5*x3 >= 0, name="unboxing_limitation")

# Shopping ads requirement
m.addConstr(0.2*x1 - 0.8*x2 + 0.2*x3 <= 0, name="shopping_requirement")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"DIY Ads: {x1.varValue}")
    print(f"Shopping Ads: {x2.varValue}")
    print(f"Unboxing Ads: {x3.varValue}")
    print(f"Max Viewership: {m.objVal}")
else:
    print("No optimal solution found")
