
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Amazing_Arts")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="large_artworks")
y = m.addVar(vtype=GRB.INTEGER, name="small_artworks")

# Set objective
m.setObjective(200*x + 75*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 3*y <= 200, "paint")
m.addConstr(3*x + y <= 100, "glitter")
m.addConstr(4*x + 2*y <= 80, "glue")
m.addConstr(x >= 5, "min_large")
m.addConstr(y >= 10, "min_small")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of large artworks: {x.x}")
    print(f"Number of small artworks: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

