
from gurobipy import *

# Create a new model
m = Model("Artworks_Production")

# Decision variables
L = m.addVar(vtype=GRB.CONTINUOUS, name="Large_Artworks")
S = m.addVar(vtype=GRB.CONTINUOUS, name="Small_Artworks")

# Objective function: Maximize profit
m.setObjective(200*L + 75*S, GRB.MAXIMIZE)

# Constraints
m.addConstr(5*L + 3*S <= 200, "Paint_Constraint")
m.addConstr(3*L + S <= 100, "Glitter_Constraint")
m.addConstr(4*L + 2*S <= 80, "Glue_Constraint")
m.addConstr(L >= 5, "Min_Large_Artworks")
m.addConstr(S >= 10, "Min_Small_Artworks")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Large Artworks: {L.x}")
    print(f"Small Artworks: {S.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
