
import gurobi

def solve_artwork_problem():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    L = model.addVar(lb=5, name="Large_Artworks")  # At least 5 large artworks
    S = model.addVar(lb=10, name="Small_Artworks")  # At least 10 small artworks

    # Objective function: Maximize profit
    model.setObjective(200*L + 75*S, gurobi.GRB.MAXIMIZE)

    # Resource constraints
    model.addConstr(5*L + 3*S <= 200, name="Paint_Constraint")
    model.addConstr(3*L + S <= 100, name="Glitter_Constraint")
    model.addConstr(4*L + 2*S <= 80, name="Glue_Constraint")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Large artworks: {L.varValue}, Small artworks: {S.varValue}")
        print(f"Maximum profit: ${200*L.varValue + 75*S.varValue}")
    else:
        print("No optimal solution found.")

solve_artwork_problem()
