
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("camera_profit")

# Create variables
l = m.addVar(lb=0, vtype=GRB.INTEGER, name="lenses")  # Integer number of lenses
t = m.addVar(lb=0, vtype=GRB.INTEGER, name="tripods") # Integer number of tripods

# Set objective
m.setObjective(200 * l + 150 * t, GRB.MAXIMIZE)

# Add constraints
m.addConstr(400 * l + 300 * t <= 10000, "budget")
m.addConstr(l >= 10, "min_lenses")
m.addConstr(l <= 25, "max_lenses")
m.addConstr(t <= (1/3) * l, "tripod_limit")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: {m.objVal}")
    print(f"Number of Lenses: {l.x}")
    print(f"Number of Tripods: {t.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

