
from gurobipy import *

# Create a model
m = Model("Camera_Store_Optimization")

# Define decision variables
lenses = m.addVar(lb=10, ub=25, vtype=GRB.INTEGER, name="lenses")
tripods = m.addVar(vtype=GRB.INTEGER, name="tripods")

# Objective function: Maximize profit
m.setObjective(200 * lenses + 150 * tripods, GRB.MAXIMIZE)

# Constraints
m.addConstr(400 * lenses + 300 * tripods <= 10000, "Budget_Constraint")
m.addConstr(tripods <= (1/3) * lenses, "Tripod_Limit")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of lenses to sell: {lenses.x}")
    print(f"Number of tripods to sell: {tripods.x}")
    print(f"Maximum profit: ${200 * lenses.x + 150 * tripods.x:.2f}")
else:
    print("No optimal solution found")
