
import gurobipy as gp

# Create a new model
model = gp.Model("MilkCompanyOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ice_cream")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheese")

# Set objective function
model.setObjective(2.5 * x + 4 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x <= 50, "ice_cream_limit")
model.addConstr(y <= 80, "cheese_limit")
model.addConstr(x + y <= 100, "machine_limit")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Ice Cream Units: {x.x}")
    print(f"Cheese Units: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {model.status}")

