
from gurobipy import *

# Create a new model
m = Model("Ice Cream and Cheese Production")

# Define the decision variables
x = m.addVar(name="ice_cream_units", lb=0)  # Units of ice cream
y = m.addVar(name="cheese_units", lb=0)     # Units of cheese

# Objective function: Maximize profits
m.setObjective(2.5*x + 4*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(x <= 50, name="ice_cream_max_production")
m.addConstr(y <= 80, name="cheese_max_production")
m.addConstr(x + y <= 100, name="processing_machine_capacity")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {x.x} units of ice cream and {y.x} units of cheese.")
else:
    print("No optimal solution found. The problem might be infeasible.")

