
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, ub=50, name="ice_cream_units")
    y = model.addVar(lb=0, ub=80, name="cheese_units")

    # Objective function: Maximize profit
    model.setObjective(2.5 * x + 4 * y, gurobi.GRB.MAXIMIZE)

    # Shared processing machine limit
    model.addConstr(x + y <= 100, name="shared_machine_limit")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Ice Cream = {x.varValue}, Cheese = {y.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
