
import gurobipy as gp

# Create a new model
model = gp.Model("ChessboardProduction")

# Create decision variables
x = model.addVar(vtype=gp.GRB.INTEGER, name="small_chessboards") # Integer number of small chessboards
y = model.addVar(vtype=gp.GRB.INTEGER, name="large_chessboards") # Integer number of large chessboards


# Set the objective function
model.setObjective(4*x + 8*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 10*y <= 400, "cutting_constraint")
model.addConstr(10*x + 20*y <= 700, "assembly_constraint")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small chessboards: {x.x}")
    print(f"Number of large chessboards: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

