
from gurobipy import *

# Create a new model
m = Model("chessboard_production")

# Define the decision variables
x = m.addVar(vtype=GRB.INTEGER, name="small_chessboards")
y = m.addVar(vtype=GRB.INTEGER, name="large_chessboards")

# Set the objective function to maximize profit
m.setObjective(4*x + 8*y, GRB.MAXIMIZE)

# Add constraints for cutting and assembly time
m.addConstr(5*x + 10*y <= 400, "cutting_time")
m.addConstr(10*x + 20*y <= 700, "assembly_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x.x} small chessboards and {y.x} large chessboards.")
else:
    print("No optimal solution found")
