
import gurobi as gp

# Create a new model
m = gp.Model("Chessboard_Production")

# Define variables
x = m.addVar(name="small_chessboards", lb=0, vtype=gp.GRB.CONTINUOUS)
y = m.addVar(name="large_chessboards", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define objective function
m.setObjective(4*x + 8*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 10*y <= 400, name="cutting_time")
m.addConstr(10*x + 20*y <= 700, name="assembly_time")

# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Produce {x.varValue} small chessboards.")
    print(f"Produce {y.varValue} large chessboards.")
    print(f"Max Profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
