
import gurobipy as gp

# Create a new model
model = gp.Model("fruit_bowls")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="small_bowls")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="large_bowls")

# Set objective function
model.setObjective(5*x + 8*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 5*y <= 100, "kiwi_constraint")
model.addConstr(2*x + 4*y <= 120, "mango_constraint")
model.addConstr(5*x + 8*y <= 150, "pineapple_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small bowls: {x.x}")
    print(f"Number of large bowls: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

