
from gurobipy import *

# Create a new model
m = Model("Tropical_Fruit_Bowls")

# Define the decision variables
x = m.addVar(name="small_bowls", vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name="large_bowls", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function: Maximize profit
m.setObjective(5*x + 8*y, GRB.MAXIMIZE)

# Add constraints based on fruit availability
m.addConstr(3*x + 5*y <= 100, name="kiwi_constraint")
m.addConstr(2*x + 4*y <= 120, name="mango_constraint")
m.addConstr(5*x + 8*y <= 150, name="pineapple_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Sell {x.x} small bowls and {y.x} large bowls.")
    print(f"Maximum profit: ${5*x.x + 8*y.x}")
else:
    print("No optimal solution found.")
