
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="small_bowls")
y = model.addVar(lb=0, name="large_bowls")

# Define the objective function
model.setObjective(5 * x + 8 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(3 * x + 5 * y <= 100, name="kiwi_constraint")
model.addConstr(2 * x + 4 * y <= 120, name="mango_constraint")
model.addConstr(5 * x + 8 * y <= 150, name="pineapple_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Small bowls: {x.varValue}")
    print(f"Large bowls: {y.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found")
