
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("blanket_bedsheet_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="blankets")  # blankets
y = m.addVar(vtype=GRB.CONTINUOUS, name="bedsheets") # bedsheets

# Set objective
m.setObjective(24 * x + 21 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * x + 17 * y <= 2000, "cutting_time")
m.addConstr(12 * x + 14 * y <= 1500, "hemming_time")
m.addConstr(x >= 0, "blankets_nonnegative")  # explicitly add non-negativity
m.addConstr(y >= 0, "bedsheets_nonnegative") # explicitly add non-negativity


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of blankets to produce: {x.x}")
    print(f"Number of bedsheets to produce: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

