
from gurobipy import *

# Create a model
m = Model("Blankets_and_Bedsheets")

# Define decision variables
B = m.addVar(vtype=GRB.CONTINUOUS, name="Blankets", lb=0)
S = m.addVar(vtype=GRB.CONTINUOUS, name="Bedsheets", lb=0)

# Set the objective function to maximize profit
m.setObjective(24*B + 21*S, GRB.MAXIMIZE)

# Add constraints for cutting and hemming time
m.addConstr(14*B + 17*S <= 2000, "Cutting_Time")
m.addConstr(12*B + 14*S <= 1500, "Hemming_Time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Blankets: {B.x}")
    print(f"Number of Bedsheets: {S.x}")
    print(f"Total Profit: ${24*B.x + 21*S.x:.2f}")
else:
    print("No optimal solution found")
