
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    B = model.addVar(lb=0, name="Blankets")  # Number of blankets
    D = model.addVar(lb=0, name="Bedsheets")  # Number of bedsheets

    # Objective function: Maximize profit
    model.setObjective(24 * B + 21 * D, gurobi.GRB.MAXIMIZE)

    # Cutting time constraint
    model.addConstr(14 * B + 17 * D <= 2000, name="Cutting_Time")

    # Hemming time constraint
    model.addConstr(12 * B + 14 * D <= 1500, name="Hemming_Time")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of blankets to produce: {B.varValue}")
        print(f"Number of bedsheets to produce: {D.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_production_problem()
