
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Farm_Optimization")

# Create decision variables
x = m.addVar(lb=0, name="apple_acres")
y = m.addVar(lb=0, name="orange_acres")

# Set objective function
m.setObjective(500*x + 450*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 80, "land_constraint")
m.addConstr(30*x + 25*y <= 2200, "soil_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of apple trees")
    print(f"Plant {y.x:.2f} acres of orange trees")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

