
from gurobipy import *

# Create a new model
m = Model("Farmer_Profit")

# Define variables
A = m.addVar(lb=0, name="Apple_Trees_Acres")
O = m.addVar(lb=0, name="Orange_Trees_Acres")

# Set the objective function
m.setObjective(500*A + 450*O, GRB.MAXIMIZE)

# Add constraints
m.addConstr(A + O <= 80, "Total_Land_Constraint")
m.addConstr(30*A + 25*O <= 2200, "Special_Soil_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {A.varName} = {A.x}, {O.varName} = {O.x}")
    print(f"Maximum Profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
