
import gurobi

def solve_farmers_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    A = model.addVar(lb=0, name="Apple_acres")
    O = model.addVar(lb=0, name="Orange_acres")

    # Objective function: Maximize profit
    model.setObjective(500*A + 450*O, gurobi.GRB.MAXIMIZE)

    # Land constraint
    model.addConstr(A + O <= 80, name="Land_constraint")

    # Soil constraint
    model.addConstr(30*A + 25*O <= 2200, name="Soil_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres for Apple trees: {A.varValue}")
        print(f"Optimal acres for Orange trees: {O.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The model is infeasible")

# Run the function
solve_farmers_problem()
