
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("candy_mixture")

    # Create variables
    x = m.addVar(vtype=GRB.CONTINUOUS, name="sour_drops")
    y = m.addVar(vtype=GRB.CONTINUOUS, name="sour_belts")


    # Set objective function
    m.setObjective(0.5*x + 0.4*y, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2*x + 4*y >= 30, "sourness")
    m.addConstr(4*x + 3*y >= 40, "flavoring")
    m.addConstr(y <= 5, "sour_belt_limit")

    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print(f"Optimal Cost: {m.objVal}")
        print(f"Number of Sour Drops: {x.x}")
        print(f"Number of Sour Belts: {y.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
