
from gurobipy import *

# Create a model
m = Model("Candy_Mixture")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="sour_drops")
y = m.addVar(vtype=GRB.CONTINUOUS, name="sour_belts")

# Set the objective function
m.setObjective(0.5*x + 0.4*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x + 4*y >= 30, "sourness_constraint")
m.addConstr(4*x + 3*y >= 40, "flavoring_constraint")
m.addConstr(y <= 5, "belt_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sour Drops: {x.x}")
    print(f"Sour Belts: {y.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")
