
import gurobi

def solve_candy_mixture_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="sour_drops")  # Number of sour drops
    y = model.addVar(lb=0, name="sour_belts")  # Number of sour belts

    # Objective function: Minimize cost
    model.setObjective(0.50 * x + 0.40 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x + 4 * y >= 30, name="sourness_constraint")
    model.addConstr(4 * x + 3 * y >= 40, name="flavoring_constraint")
    model.addConstr(y <= 5, name="sour_belt_limit")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_candy_mixture_problem()
