
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("toy_production")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="dolls")  # Number of dolls
y = m.addVar(vtype=GRB.INTEGER, name="soldiers") # Number of soldiers

# Set objective function
m.setObjective(8*x + 10*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 15*y <= 1000, "crafting_time")
m.addConstr(5*x + 8*y <= 800, "sanding_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Dolls: {x.x}")
    print(f"Number of Soldiers: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

