
from gurobipy import *

# Create a model
m = Model("Wooden_Toys")

# Define decision variables
D = m.addVar(vtype=GRB.CONTINUOUS, name="dolls", lb=0)
S = m.addVar(vtype=GRB.CONTINUOUS, name="soldiers", lb=0)

# Objective function: Maximize profit
m.setObjective(8*D + 10*S, GRB.MAXIMIZE)

# Constraints
m.addConstr(10*D + 15*S <= 1000, "crafting_time")
m.addConstr(5*D + 8*S <= 800, "sanding_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Dolls: {D.x}")
    print(f"Soldiers: {S.x}")
    print(f"Maximum Profit: ${8*D.x + 10*S.x:.2f}")
else:
    print("No optimal solution found")
