
import gurobi

def solve_toy_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    D = model.addVar(lb=0, name="Dolls")
    S = model.addVar(lb=0, name="Soldiers")

    # Objective function: Maximize profit
    model.setObjective(8 * D + 10 * S, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10 * D + 15 * S <= 1000, name="Crafting_Time")
    model.addConstr(5 * D + 8 * S <= 800, name="Sanding_Time")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Profit: ${model.objVal}")
        print(f"Dolls: {D.varValue}, Soldiers: {S.varValue}")
    else:
        print("No optimal solution found.")

# Run the function
solve_toy_shop_problem()
