
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Berry_Farming")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="blueberries")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="raspberries")

# Set objective function
m.setObjective(200*x + 250*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 300, "land")
m.addConstr(60*x + 40*y <= 20000, "fertilizer")
m.addConstr(3*x + 4*y <= 400, "picking_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of blueberries")
    print(f"Plant {y.x:.2f} acres of raspberries")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

