
from gurobipy import *

# Create a new model
m = Model("Berry_Farming")

# Define variables
blueberry_acres = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Blueberry_Acres")
raspberry_acres = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Raspberry_Acres")

# Set the objective function: Maximize profit
m.setObjective(200*blueberry_acres + 250*raspberry_acres, GRB.MAXIMIZE)

# Add constraints
m.addConstr(60*blueberry_acres + 40*raspberry_acres <= 20000, name="Fertilizer_Budget")
m.addConstr(3*blueberry_acres + 4*raspberry_acres <= 400, name="Picking_Time")
m.addConstr(blueberry_acres + raspberry_acres <= 300, name="Land_Availability")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Blueberries = {blueberry_acres.x}, Raspberries = {raspberry_acres.x}")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found")
