
import gurobi

def solve_berry_farming_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(lb=0, name="Blueberries acres")
    R = model.addVar(lb=0, name="Raspberries acres")

    # Objective function: Maximize profit
    model.setObjective(200*B + 250*R, gurobi.GRB.MAXIMIZE)

    # Land constraint
    model.addConstr(B + R <= 300, name="Land_Constraint")

    # Fertilizer cost constraint
    model.addConstr(60*B + 40*R <= 20000, name="Fertilizer_Constraint")

    # Picking hours constraint
    model.addConstr(3*B + 4*R <= 400, name="Picking_Hours_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of blueberries: {B.varValue}")
        print(f"Optimal acres of raspberries: {R.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_berry_farming_problem()
