
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Keyboard_Production")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="regular_keyboards")
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="mechanical_keyboards")

# Set objective function
model.setObjective(30*x + 60*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x >= 165, "demand_regular")
model.addConstr(y >= 70, "demand_mechanical")
model.addConstr(x <= 300, "capacity_regular")
model.addConstr(y <= 150, "capacity_mechanical")
model.addConstr(x + y >= 250, "total_production")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Regular Keyboards: {x.x}")
    print(f"Mechanical Keyboards: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

