
from gurobipy import *

# Create a new model
m = Model("Keyboard_Factory")

# Define variables
R = m.addVar(lb=0, name="Regular_Keyboards")
M = m.addVar(lb=0, name="Mechanical_Keyboards")

# Objective function: Maximize profit
m.setObjective(30*R + 60*M, GRB.MAXIMIZE)

# Constraints
m.addConstr(R >= 165, "Demand_Regular")
m.addConstr(M >= 70, "Demand_Mechanical")
m.addConstr(R <= 300, "Production_Limit_Regular")
m.addConstr(M <= 150, "Production_Limit_Mechanical")
m.addConstr(R + M >= 250, "Contract_Requirement")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Regular Keyboards: {R.x}")
    print(f"Mechanical Keyboards: {M.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found.")

